Ext.data.JsonP.sol_common_ix_functions_Status({"tagname":"class","name":"sol.common.ix.functions.Status","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"sol.common.ix.functions.Status.js","href":"sol.common.ix.functions.Status.html#sol-common-ix-functions-Status"}],"author":[{"tagname":"author","name":"ELO Digital Office GmbH","email":null}],"eloix":true,"requires":["sol.Logger","sol.common.AclUtils","sol.common.CounterUtils","sol.common.JsonUtils","sol.common.ObjectFormatter.TemplateSord","sol.common.RepoUtils","sol.common.SordUtils","sol.common.Template","sol.common.TranslateTerms","sol.common.WfUtils","sol.common.ix.FunctionBase","sol.common.ix.RfUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.common.ix.FunctionBase","mixins":[],"uses":[],"members":[{"name":"dynKwlCfg","tagname":"cfg","owner":"sol.common.ix.functions.Status","id":"cfg-dynKwlCfg","meta":{}},{"name":"group","tagname":"cfg","owner":"sol.common.ix.functions.Status","id":"cfg-group","meta":{"required":true}},{"name":"objId","tagname":"cfg","owner":"sol.common.ix.FunctionBase","id":"cfg-objId","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.common.ix.functions.Status","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"status","tagname":"cfg","owner":"sol.common.ix.functions.Status","id":"cfg-status","meta":{"required":true}},{"name":"useDynKwl","tagname":"cfg","owner":"sol.common.ix.functions.Status","id":"cfg-useDynKwl","meta":{}},{"name":"useKwl","tagname":"cfg","owner":"sol.common.ix.functions.Status","id":"cfg-useKwl","meta":{}},{"name":"useTemplating","tagname":"cfg","owner":"sol.common.ix.functions.Status","id":"cfg-useTemplating","meta":{}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.common.ix.FunctionBase","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"getStatus","tagname":"method","owner":"sol.common.ix.functions.Status","id":"method-getStatus","meta":{"private":true}},{"name":"getStatusFromDynKwl","tagname":"method","owner":"sol.common.ix.functions.Status","id":"method-getStatusFromDynKwl","meta":{"private":true}},{"name":"getStatusFromKwl","tagname":"method","owner":"sol.common.ix.functions.Status","id":"method-getStatusFromKwl","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.functions.Status","id":"method-initialize","meta":{"private":true}},{"name":"process","tagname":"method","owner":"sol.common.ix.functions.Status","id":"method-process","meta":{}},{"name":"RF_sol_function_Status","tagname":"method","owner":"sol.common.ix.functions.Status","id":"static-method-RF_sol_function_Status","meta":{"static":true}},{"name":"onEnterNode","tagname":"method","owner":"sol.common.ix.functions.Status","id":"static-method-onEnterNode","meta":{"static":true}},{"name":"onExitNode","tagname":"method","owner":"sol.common.ix.functions.Status","id":"static-method-onExitNode","meta":{"static":true}}],"code_type":"ext_define","id":"class-sol.common.ix.functions.Status","short_doc":"Writes a status into a index field, either directly or tries to read it from a keyword list. ...","classIcon":"icon-class","superclasses":["sol.Base","sol.common.ix.FunctionBase"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a><div class='subclass '><strong>sol.common.ix.functions.Status</strong></div></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.Logger' rel='sol.Logger' class='docClass'>sol.Logger</a></div><div class='dependency'><a href='#!/api/sol.common.AclUtils' rel='sol.common.AclUtils' class='docClass'>sol.common.AclUtils</a></div><div class='dependency'><a href='#!/api/sol.common.CounterUtils' rel='sol.common.CounterUtils' class='docClass'>sol.common.CounterUtils</a></div><div class='dependency'><a href='#!/api/sol.common.JsonUtils' rel='sol.common.JsonUtils' class='docClass'>sol.common.JsonUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ObjectFormatter.TemplateSord' rel='sol.common.ObjectFormatter.TemplateSord' class='docClass'>sol.common.ObjectFormatter.TemplateSord</a></div><div class='dependency'><a href='#!/api/sol.common.RepoUtils' rel='sol.common.RepoUtils' class='docClass'>sol.common.RepoUtils</a></div><div class='dependency'><a href='#!/api/sol.common.SordUtils' rel='sol.common.SordUtils' class='docClass'>sol.common.SordUtils</a></div><div class='dependency'><a href='#!/api/sol.common.Template' rel='sol.common.Template' class='docClass'>sol.common.Template</a></div><div class='dependency'><a href='#!/api/sol.common.TranslateTerms' rel='sol.common.TranslateTerms' class='docClass'>sol.common.TranslateTerms</a></div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><div class='dependency'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='docClass'>sol.common.ix.FunctionBase</a></div><div class='dependency'><a href='#!/api/sol.common.ix.RfUtils' rel='sol.common.ix.RfUtils' class='docClass'>sol.common.ix.RfUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.functions.Status.html#sol-common-ix-functions-Status' target='_blank'>sol.common.ix.functions.Status.js</a></div></pre><div class='doc-contents'><p>Writes a status into a index field, either directly or tries to read it from a keyword list.</p>\n\n<h1>As workflow node</h1>\n\n<p>ObjId is set based on the element that the workflow is attached to.</p>\n\n<p>Following configuration should be applied to the 'script properties' field for a status update:</p>\n\n<pre><code>{\n  \"group\": \"MY_INDEX_FIELD\",\n  \"status\": \"DONE\"\n}\n</code></pre>\n\n<p>Following configuration should be applied to the 'script properties' field and will load a status from the fields KWL staring with '3'</p>\n\n<pre><code>{\n  \"group\": \"MY_INDEX_FIELD_WITH_ELO_KWL\",\n  \"status\": \"3\",\n  \"useKwl\": true\n}\n</code></pre>\n\n<p>Following configuration will load a status from the fields dynamic KWL staring with 'M' (e.g. M - month) from a localized dynamic KWL</p>\n\n<pre><code>{\n  \"group\": \"REMINDER_PERIOD_UNIT\",\n  \"status\": \"M\",\n  \"useDynKwl\": true,\n  \"dynKwlCfg\": {\n    \"returnColumn\": 2,\n    \"filterColumn\": 0\n  }\n}\n</code></pre>\n\n<h1>As IX function call</h1>\n\n<p>In addition to the workflow node configuration the objId must be passed.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_sol_function_Status', {\n  objId: \"4711\",\n  group: \"MY_INDEX_FIELD_WITH_ELO_KWL\",\n  status: \"3\",\n  useKwl: true\n});\n</code></pre>\n</div><div class='members'><div class='members-section'><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Required config options</h3><div id='cfg-group' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Status'>sol.common.ix.functions.Status</span><br/><a href='source/sol.common.ix.functions.Status.html#sol-common-ix-functions-Status-cfg-group' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Status-cfg-group' class='name expandable'>group</a> : string<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'><p>group field to write the change to</p>\n</div><div class='long'><p>group field to write the change to</p>\n</div></div></div><div id='cfg-status' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Status'>sol.common.ix.functions.Status</span><br/><a href='source/sol.common.ix.functions.Status.html#sol-common-ix-functions-Status-cfg-status' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Status-cfg-status' class='name expandable'>status</a> : string<span class=\"signature\"><span class='required' >required</span></span></div><div class='description'><div class='short'>If neither useKwl nor useDynKwl is defined, this value will be written to the group field. ...</div><div class='long'><p>If neither <code>useKwl</code> nor <code>useDynKwl</code> is defined, this value will be written to the group field.\nIf one of both is defined though, this will be used as a 'startsWith' filter on the KWL entries.</p>\n</div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Optional config options</h3><div id='cfg-dynKwlCfg' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Status'>sol.common.ix.functions.Status</span><br/><a href='source/sol.common.ix.functions.Status.html#sol-common-ix-functions-Status-cfg-dynKwlCfg' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Status-cfg-dynKwlCfg' class='name expandable'>dynKwlCfg</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional) ...</div><div class='long'><p>(optional)</p>\n<ul><li><span class='pre'>returnColumn</span> : Object<div class='sub-desc'><p>(optional)</p>\n</div></li><li><span class='pre'>filterColumn</span> : Object<div class='sub-desc'><p>(optional)\nAdditional configuration for dynamic KWL queries (see <a href=\"#!/api/sol.common.SordUtils-method-getDynamicKeywordlistValue\" rel=\"sol.common.SordUtils-method-getDynamicKeywordlistValue\" class=\"docClass\">sol.common.SordUtils.getDynamicKeywordlistValue</a>)</p>\n</div></li></ul></div></div></div><div id='cfg-objId' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-cfg-objId' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-cfg-objId' class='name expandable'>objId</a> : string<span class=\"signature\"></span></div><div class='description'><div class='short'><p>Object ID for the element</p>\n</div><div class='long'><p>Object ID for the element</p>\n</div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Status'>sol.common.ix.functions.Status</span><br/><a href='source/sol.common.ix.functions.Status.html#sol-common-ix-functions-Status-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Status-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;objId&quot;, &quot;group&quot;, &quot;status&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div><div id='cfg-useDynKwl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Status'>sol.common.ix.functions.Status</span><br/><a href='source/sol.common.ix.functions.Status.html#sol-common-ix-functions-Status-cfg-useDynKwl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Status-cfg-useDynKwl' class='name expandable'>useDynKwl</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nIf specified, the script reads the KWL from group field and retrieves keyword starting with status ...</div><div class='long'><p>(optional)\nIf specified, the script reads the KWL from group field and retrieves keyword starting with status</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-useKwl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Status'>sol.common.ix.functions.Status</span><br/><a href='source/sol.common.ix.functions.Status.html#sol-common-ix-functions-Status-cfg-useKwl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Status-cfg-useKwl' class='name expandable'>useKwl</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nIf specified, the script reads the KWL from group field and retrieves keyword starting with status ...</div><div class='long'><p>(optional)\nIf specified, the script reads the KWL from group field and retrieves keyword starting with status</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-useTemplating' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Status'>sol.common.ix.functions.Status</span><br/><a href='source/sol.common.ix.functions.Status.html#sol-common-ix-functions-Status-cfg-useTemplating' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Status-cfg-useTemplating' class='name expandable'>useTemplating</a> : Boolean<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nIf specified, the status will be handled as a handlebars string (see sol.common.Template for more informat...</div><div class='long'><p>(optional)\nIf specified, the <a href=\"#!/api/sol.common.ix.functions.Status-cfg-status\" rel=\"sol.common.ix.functions.Status-cfg-status\" class=\"docClass\">status</a> will be handled as a handlebars string (see <a href=\"#!/api/sol.common.Template\" rel=\"sol.common.Template\" class=\"docClass\">sol.common.Template</a> for more information).\nThe templating will be processed before any further executions (like <code>useKwl</code> or <code>useDynKwl</code>).\nThe template has access to at least the current sord:</p>\n\n<pre><code>{ \"group\": \"INVOICE_STATUS\", \"useTemplating\": true, \"status\": \"OPEN_{{sord.objKeys.INVOICE_TYPE}}\" }\n{ \"group\": \"INVOICE_NUMBER\", \"useTemplating\": true, \"status\": \"{{count 'MY_INVOICE_COUNTER'}}\" }\n</code></pre>\n<p>Defaults to: <code>false</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.common.ix.FunctionBase' rel='sol.common.ix.FunctionBase' class='defined-in docClass'>sol.common.ix.FunctionBase</a><br/><a href='source/lib_sol.common.ix.FunctionBase.html#sol-common-ix-FunctionBase-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.FunctionBase-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>The logger for the module</p>\n</div><div class='long'><p>The logger for the module</p>\n<p>Overrides: <a href=\"#!/api/sol.Base-property-logger\" rel=\"sol.Base-property-logger\" class=\"docClass\">sol.Base.logger</a></p></div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance methods</h3><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-getStatus' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Status'>sol.common.ix.functions.Status</span><br/><a href='source/sol.common.ix.functions.Status.html#sol-common-ix-functions-Status-method-getStatus' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Status-method-getStatus' class='name expandable'>getStatus</a>( <span class='pre'>sord</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves the status. ...</div><div class='long'><p>Retrieves the status. If <code>useTemplating===true</code> it will apply handlebars using the current sord as data.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>sord</span> : de.elo.ix.client.Sord<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getStatusFromDynKwl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Status'>sol.common.ix.functions.Status</span><br/><a href='source/sol.common.ix.functions.Status.html#sol-common-ix-functions-Status-method-getStatusFromDynKwl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Status-method-getStatusFromDynKwl' class='name expandable'>getStatusFromDynKwl</a>( <span class='pre'>maskName, statusPrefix, field, cfg</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves a status string from the dynamic keyword list of the spezified field. ...</div><div class='long'><p>Retrieves a status string from the dynamic keyword list of the spezified field.\nIt checks, if one of the entries in the keyword list starts with the statusPrefix.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>maskName</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>statusPrefix</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>field</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>cfg</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The found item from the keyword list or the statusPrefix, if nothing was found</p>\n</div></li></ul></div></div></div><div id='method-getStatusFromKwl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Status'>sol.common.ix.functions.Status</span><br/><a href='source/sol.common.ix.functions.Status.html#sol-common-ix-functions-Status-method-getStatusFromKwl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Status-method-getStatusFromKwl' class='name expandable'>getStatusFromKwl</a>( <span class='pre'>statusPrefix, field</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves a status string from the keyword list of the spezified field. ...</div><div class='long'><p>Retrieves a status string from the keyword list of the spezified field.\nIt checks, if one of the entries in the keyword list starts with the statusPrefix.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>statusPrefix</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>field</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>The found item from the keyword list or the statusPrefix, if nothing was found</p>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Status'>sol.common.ix.functions.Status</span><br/><a href='source/sol.common.ix.functions.Status.html#sol-common-ix-functions-Status-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Status-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'></div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-process' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Status'>sol.common.ix.functions.Status</span><br/><a href='source/sol.common.ix.functions.Status.html#sol-common-ix-functions-Status-method-process' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Status-method-process' class='name expandable'>process</a>( <span class='pre'></span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Sets the status. ...</div><div class='long'><p>Sets the status.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-process\" rel=\"sol.common.ix.FunctionBase-method-process\" class=\"docClass\">sol.common.ix.FunctionBase.process</a></p></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static methods</h3><div id='static-method-RF_sol_function_Status' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Status'>sol.common.ix.functions.Status</span><br/><a href='source/sol.common.ix.functions.Status.html#sol-common-ix-functions-Status-static-method-RF_sol_function_Status' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Status-static-method-RF_sol_function_Status' class='name expandable'>RF_sol_function_Status</a>( <span class='pre'>Execution, args</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n...</div><div class='long'><p>This function can be called from an application by invoking the API function \"executeRegisteredFunction\" or by using\n<a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a> which internally handles the Any-Object conversion.</p>\n\n<p>All configuration params should be passed as a configuration object to the args param.</p>\n\n<pre><code><a href=\"#!/api/sol.common.IxUtils-method-execute\" rel=\"sol.common.IxUtils-method-execute\" class=\"docClass\">sol.common.IxUtils.execute</a>('RF_FunctionName', {\n  configParam1: 'myParam'\n});\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>Execution</span> : de.elo.ix.client.IXServerEventsContext<div class='sub-desc'><p>context</p>\n</div></li><li><span class='pre'>args</span> : Object<div class='sub-desc'><p>Argument array sent by the client application.</p>\n</div></li></ul></div></div></div><div id='static-method-onEnterNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Status'>sol.common.ix.functions.Status</span><br/><a href='source/sol.common.ix.functions.Status.html#sol-common-ix-functions-Status-static-method-onEnterNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Status-static-method-onEnterNode' class='name expandable'>onEnterNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called before a workflow node is activated. ...</div><div class='long'><p>This function is called before a workflow node is activated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The activated node ID</p>\n</div></li></ul></div></div></div><div id='static-method-onExitNode' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.functions.Status'>sol.common.ix.functions.Status</span><br/><a href='source/sol.common.ix.functions.Status.html#sol-common-ix-functions-Status-static-method-onExitNode' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.functions.Status-static-method-onExitNode' class='name expandable'>onExitNode</a>( <span class='pre'>clInfo, userId, wFDiagram, nodeId</span> )<span class=\"signature\"><span class='static' >static</span></span></div><div class='description'><div class='short'>This function is called after a workflow node is deactivated. ...</div><div class='long'><p>This function is called after a workflow node is deactivated.</p>\n\n<p>The configuration for this function can be defined in the comments section of each workflow node and should be valid js.\nFor more information on using this function please refer to the functions documentation.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>clInfo</span> : de.elo.ix.client.ClientInfo<div class='sub-desc'><p>object with language, country and ticket</p>\n</div></li><li><span class='pre'>userId</span> : number<div class='sub-desc'><p>The calling users ID</p>\n</div></li><li><span class='pre'>wFDiagram</span> : de.elo.ix.client.WFDiagram<div class='sub-desc'>\n</div></li><li><span class='pre'>nodeId</span> : number<div class='sub-desc'><p>The deactivated node ID</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloix":true}});